﻿using System.Collections.Generic;

namespace MonitorExamples
{
    // Listing 16-9. Kod niedostosowany do działania wielowątkowego
    class MostRecentlyUsed
    {
        private List<string> items = new List<string>();
        private int maxItems;

        public MostRecentlyUsed(int maximumItemCount)
        {
            maxItems = maximumItemCount;
        }

        public void UseItem(string item)
        {
            // Jeśli element już jest na liście i nie jest jej pierwszym
            // elementem, to usuwamy go z aktualnie zajmowanego miejsca,
            // gdyż zamierzamy umieścić go na pierwszym miejscu.
            int itemIndex = items.IndexOf(item);
            if (itemIndex > 0)
            {
                items.RemoveAt(itemIndex);
            }

            // Jeśli element już jest pierwszy, nie musimy nic robić.
            if (itemIndex != 0)
            {
                items.Insert(0, item);
                // Upewniamy się, że liczba elementów listy nie przekroczy 
                // dopuszczalnego limitu.
                if (items.Count > maxItems)
                {
                    items.RemoveAt(items.Count - 1);
                }
            }
        }

        public IEnumerable<string> GetItems()
        {
            return items.ToArray();
        }
    }
}
